    let map; // Leaflet map instance


        addEventListener('load', () => {
            document.getElementById('geoButton').addEventListener('click', showLocation);
        });


        // Promise
        async function getLocation() {

            return new Promise((resolve, reject) => {
                if (!navigator.geolocation) {
                    reject("Geolocation is not supported by your browser.");
                } else {
                    navigator.geolocation.getCurrentPosition(
                        position => resolve(position),
                        error => reject(error)
                    );
                }
            });
        }

/*
        // Callback

        function getLocation(successCallback, errorCallback) {
            if (!navigator.geolocation) {
                if (errorCallback) errorCallback("Geolocation is not supported by your browser.");
            } else {
                navigator.geolocation.getCurrentPosition(
                    position => {
                        if (successCallback) successCallback(position);
                    },
                    error => {
                        if (errorCallback) errorCallback(error);
                    }
                );
            }
        }


        // Callback usage
        getLocation(
            // success
            (position) => {
                const { latitude, longitude } = position.coords;
                console.log("Latitude:", latitude);
                console.log("Longitude:", longitude);
            },
            // error
            (error) => {
                console.error("Error:", error.message || error);
            }
        );
*/




        // Function using async/await
        async function showLocation() {

            const geoResult = document.getElementById('geoResult');
            const coordsDiv = document.getElementById('coords');
            const msg = document.getElementById('msg');

            msg.className = '';
            coordsDiv.innerHTML = '<div class="loader">🌀</div>';
            geoResult.style.display = "block";


            try {
                const position = await getLocation();

/*
                //Promise then

                getLocation().then(position => {
                        const { latitude, longitude } = position.coords;
                        console.log(latitude, longitude);
                            }).catch(error => {
                                console.error("Error:", error);
                            });
*/



                const { latitude, longitude, accuracy } = position.coords;


                // Show the map in the background
                showMap(latitude, longitude);

                coordsDiv.innerHTML = `
                    <strong>Latitude:</strong> ${latitude.toFixed(5)}<br>
                    <strong>Longitude:</strong> ${longitude.toFixed(5)}<br>
                    <strong>Accuracy:</strong> ±${accuracy.toFixed(1)} m
                `;
            } catch (error) {
                msg.textContent = `Error: ${error.message || error}`;
                msg.className = 'error';

            }
        }

        // Initialize or update map
        function showMap(lat, lon) {
            if (!map) {
                map = L.map('map').setView([lat, lon], 13);

                // Add tile layer
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19,
                    attribution: '&copy; OpenStreetMap contributors'
                }).addTo(map);

                // Marker at current position
                L.marker([lat, lon]).addTo(map)
                    .bindPopup("<b>You are here!</b>")
                    .openPopup();
            } else {
                // Update map position if it already exists
                map.setView([lat, lon], 13);
            }
        }
